function addLoadListener(fn) {
	if (typeof window.addEventListener != 'undefined') {
		window.addEventListener('load', fn, false);
	}
	else if (typeof document.addEventListener != 'undefined') {
		document.addEventListener('load', fn, false);
	}
	else if (typeof window.attachEvent != 'undefined') {
		window.attachEvent('onload', fn);
	}
	else {
		var oldfn = window.onload;
		if (typeof window.onload != 'function') {
			window.onload = fn;
		}
		else {
			window.onload = function() {
				oldfn();
				fn();
			}
		}
	}
}

function attachEventListener(target, eventType, functionRef, capture) {
	if (typeof target.addEventListener != "undefined") {
		target.addEventListener(eventType, functionRef, capture);
	}
	else if (typeof target.attachEvent != "undefined") {
		target.attachEvent("on" + eventType, functionRef);
	}
	else {
		eventType = "on" + eventType;
		if (typeof target[eventType] == "function") {
			var oldListener = target[eventType];
			target[eventType] = function() {
				oldListener();
				return functionRef();
			}
		}
		else {
			target[eventType] = functionRef;
		}
	}
}

function getEventTarget(event) {
  var targetElement = null;

  if (typeof event.target != "undefined") {
    targetElement = event.target;
  }
  else {
    targetElement = event.srcElement;
  }

  while (targetElement.nodeType == 3 && targetElement.parentNode != null) {
    targetElement = targetElement.parentNode;
  }

  return targetElement;
}

function getElementsByClass(node,searchClass,tag) {
	var classElements = new Array();
	var els = node.getElementsByTagName(tag); // use "*" for all elements
	var elsLen = els.length;
	var pattern = new RegExp("\\b"+searchClass+"\\b");
	for (i = 0, j = 0; i < elsLen; i++) {
		if ( pattern.test(els[i].className) ) {
			classElements[j] = els[i];
			j++;
		}
	}
	return classElements;
}

function getElementsByTagNames(list,obj) {
/*
	getElementsByTagNames takes two arguments:

   1. A string with a comma-separated list of tag names.
   2. An optional start element. If it's present the
      script searches only for tags that are descendants
      of this element, if it's absent the script searches
      the entire document.
   From QuirksMode.org, the personal site of Peter-Paul Koch
*/
	if (!obj) var obj = document;
	var tagNames = list.split(',');
	var resultArray = new Array();
	for (var i=0;i<tagNames.length;i++) {
		var tags = obj.getElementsByTagName(tagNames[i]);
		for (var j=0;j<tags.length;j++) {
			resultArray.push(tags[j]);
		}
	}
	var testNode = resultArray[0];
	if (!testNode) return [];
	if (testNode.sourceIndex) {
		resultArray.sort(function (a,b) {
				return a.sourceIndex - b.sourceIndex;
		});
	}
	else if (testNode.compareDocumentPosition) {
		resultArray.sort(function (a,b) {
				return 3 - (a.compareDocumentPosition(b) & 6);
		});
	}
	return resultArray;
}

function getElementsByAttribute(attribute, attributeValue) {
	// Careful! Resource hog.
	var elementArray = new Array();
	var matchedArray = new Array();

	if (document.all) {
		elementArray = document.all;
	}
	else {
		elementArray = document.getElementsByTagName("*");
	}

	for (var i = 0; i < elementArray.length; i++) {
		if(typeof elementArray[i].className == "undefined") continue;
		if (attribute == "class") {
			var pattern = new RegExp("(^| )" + attributeValue + "( |$)");

			if (elementArray[i].className.match(pattern)) {
				matchedArray[matchedArray.length] = elementArray[i];
			}
		}
		else if (attribute == "for") {
			if (elementArray[i].getAttribute("htmlFor") 
					|| elementArray[i].getAttribute("for")) {
				if (elementArray[i].htmlFor == attributeValue) {
					matchedArray[matchedArray.length] = elementArray[i];
				}
			}
		}
		else if (elementArray[i].getAttribute(attribute) == attributeValue) {
			matchedArray[matchedArray.length] = elementArray[i];
		}
	}

	return matchedArray;
}

function getElementPosition(theElement) {
  var positionX = 0;
  var positionY = 0;

  while (theElement != null) {
    positionX += theElement.offsetLeft;
    positionY += theElement.offsetTop;
    theElement = theElement.offsetParent;
  }
  
  return [positionX, positionY];
}

function getCursorPosition(event) {
  // array for X, Y position
  var position = [0, 0];

  if (typeof event == "undefined") {
    event = window.event;
  }

  var scrollingPosition = getScrollingPosition();

  if (typeof event.pageX != "undefined" && typeof event.x != "undefined") {
    position = [event.pageX, event.pageY];
  }
  else {
    position = [event.clientX + scrollingPosition[0],
    		event.clientY + scrollingPosition[1]];
  }

  return position;
}

function getScrollingPosition() {
	// array for X, Y position
	var position = [0, 0];

	// if the window.pageYOffset property is supported
	if(typeof window.pageYOffset != 'undefined') {
		//store position values
		position = [window.pageXOffset, window.pageYOffset ];
	}

	// if the documentElement.scrollTop property is supported
	// and the value is greater than zero
	if(typeof document.documentElement.scrollTop != 'undefined'
			&& document.documentElement.scrollTop > 0) {
		position = [document.documentElement.scrollLeft,
				document.documentElement.scrollTop];
	}

	// if the body.scrollTop property is supported
	else if(typeof document.body.scrollTop != 'undefined') {
		position = [document.body.scrollLeft,
				document.body.scrollTop];
	}

	return position;
}

function clearSelectList(id) {
    var eSelect = document.getElementById(id);
    while (eSelect.length > 0) {
        eSelect.remove(0);
    }
}